/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.armor;

import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;

public class MosquitoModifier
extends TotalArmorLevelModifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> MOSQUITO = TinkerDataCapability.TinkerDataKey.of((ResourceLocation)new ResourceLocation("tcintegrations", "mosquito"));

    public MosquitoModifier() {
        super(MOSQUITO);
        MinecraftForge.EVENT_BUS.addListener(MosquitoModifier::onLivingTick);
    }

    public Component getDisplayName(int level) {
        return super.getDisplayName();
    }

    private static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        int level;
        LivingEntity entity = event.getEntityLiving();
        if (!entity.m_5833_() && (entity.f_19797_ & 1) == 0 && (level = ModifierUtil.getTotalModifierLevel((LivingEntity)entity, MOSQUITO)) > 0) {
            MosquitoModifier.applyAnnoyance(entity, level);
        }
    }

    public static void applyAnnoyance(LivingEntity entity, int level) {
        double z;
        double y;
        float range;
        double x = entity.m_20185_();
        List entities = entity.f_19853_.m_45976_(LivingEntity.class, new AABB(x - (double)(range = 3.0f + 1.0f * (float)level), (y = entity.m_20186_()) - (double)range, (z = entity.m_20189_()) - (double)range, x + (double)range, y + (double)range, z + (double)range));
        if (!entities.isEmpty() && entity.f_19797_ % 100 == 0) {
            entity.m_5496_(AMSoundRegistry.MOSQUITO_LOOP, 1.0f, 1.0f);
        }
        for (LivingEntity livingEntity : entities) {
            if (livingEntity.equals((Object)entity) || entity.f_19797_ % 20 != 0) continue;
            for (int i = 0; i < 3; ++i) {
                livingEntity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123784_, livingEntity.m_20208_(1.0), livingEntity.m_20187_(), livingEntity.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        }
    }
}

